/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.workbench.commands;

import com.aptana.core.IScopeReference;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IEditorCommandsMenuContributor;
import com.aptana.editor.common.ITopContentTypesProvider;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.scripting.commands.TextEditorUtils;
import com.aptana.scripting.model.AbstractElement;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.MenuElement;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.NotFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import com.aptana.scripting.ui.KeyBindingUtil;
import com.aptana.workbench.WorkbenchPlugin;
import com.aptana.workbench.commands.EditBundleJob;
import com.aptana.workbench.commands.Messages;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorCommandsMenuContributor
extends ContributionItem {
    private static final String TAB = "\u00bb";

    public EditorCommandsMenuContributor() {
    }

    public EditorCommandsMenuContributor(String id) {
        super(id);
    }

    public void fill(Menu menu, int index) {
        super.fill(menu, index);
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evaluationService != null) {
            IEvaluationContext currentState = evaluationService.getCurrentState();
            Object activePart = currentState.getVariable("activePart");
            if (activePart instanceof ITextEditor) {
                EditorCommandsMenuContributor.fill(menu, (ITextEditor)activePart, (IContributionItem)this);
            } else {
                EditorCommandsMenuContributor.fill(menu, null, (IContributionItem)this);
            }
        }
    }

    public boolean isDynamic() {
        return true;
    }

    private static void fill(Menu menu, ITextEditor textEditor) {
        EditorCommandsMenuContributor.fill(menu, textEditor, null);
    }

    private static void fill(Menu menu, ITextEditor textEditor, IContributionItem contributionItem) {
        String scope = null;
        LinkedList<MenuElement> menusFromScopeList = new LinkedList<MenuElement>();
        List menusFromOtherScopes = null;
        if (textEditor == null) {
            List menusFromScope;
            IScopeReference scopeRef;
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
            if (part != null && (scopeRef = (IScopeReference)part.getAdapter(IScopeReference.class)) != null) {
                scope = scopeRef.getScopeId();
            }
            if ((menusFromScope = BundleManager.getInstance().getMenus(new IModelFilter(){

                public boolean include(AbstractElement element) {
                    return true;
                }
            })).size() > 0) {
                menusFromScopeList.addAll(menusFromScope);
            }
        } else {
            SourceViewerConfiguration sourceViewerConfiguration;
            List menusFromScope;
            try {
                int caretOffset = TextEditorUtils.getCaretOffset((ITextEditor)textEditor);
                ISourceViewer viewer = TextEditorUtils.getSourceViewer((ITextEditor)textEditor);
                if (viewer == null) {
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                    scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(document, caretOffset);
                } else {
                    scope = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset((ITextViewer)viewer, caretOffset);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
            }
            if (scope != null) {
                ScopeFilter filter = new ScopeFilter(scope);
                menusFromScope = BundleManager.getInstance().getMenus((IModelFilter)filter);
                if (menusFromScope.size() > 0) {
                    menusFromScopeList.addAll(menusFromScope);
                }
            }
            if ((sourceViewerConfiguration = (SourceViewerConfiguration)textEditor.getAdapter(SourceViewerConfiguration.class)) instanceof ITopContentTypesProvider) {
                String[][] topContentTypes = ((ITopContentTypesProvider)sourceViewerConfiguration).getTopContentTypes();
                LinkedList<String> topLevelContentTypesList = new LinkedList<String>();
                String[][] stringArray = topContentTypes;
                int n = topContentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] topContentType = stringArray[n2];
                    QualifiedContentType qualifiedContentType = new QualifiedContentType(topContentType);
                    String contentType = EditorCommandsMenuContributor.getContentTypeTranslator().translate(qualifiedContentType).toString();
                    topLevelContentTypesList.add(contentType);
                    ++n2;
                }
                if (topLevelContentTypesList.size() > 0) {
                    String[] topLevelContentTypes = new String[topLevelContentTypesList.size()];
                    topLevelContentTypesList.toArray(topLevelContentTypes);
                    ScopeFilter topLevelContentTypesFilter = new ScopeFilter(topLevelContentTypes);
                    menusFromScope = BundleManager.getInstance().getMenus((IModelFilter)topLevelContentTypesFilter);
                    if (menusFromScope.size() > 0) {
                        menusFromScopeList.addAll(menusFromScope);
                    }
                    NotFilter notFilter = new NotFilter((IModelFilter)topLevelContentTypesFilter);
                    menusFromOtherScopes = BundleManager.getInstance().getMenus((IModelFilter)notFilter);
                }
            }
        }
        if (menusFromScopeList.size() > 0) {
            CollectionsUtil.removeDuplicates(menusFromScopeList);
            Collections.sort(menusFromScopeList, new Comparator<MenuElement>(){

                @Override
                public int compare(MenuElement menuElement1, MenuElement menuElement2) {
                    return menuElement1.getDisplayName().compareToIgnoreCase(menuElement2.getDisplayName());
                }
            });
            EditorCommandsMenuContributor.buildMenu(menu, menusFromScopeList, textEditor, scope, contributionItem);
        }
        if (menusFromOtherScopes != null && menusFromOtherScopes.size() > 0) {
            MenuItem separatorMenuItem = new MenuItem(menu, 2);
            separatorMenuItem.setData((Object)contributionItem);
            MenuItem menuItemForOtherScopes = new MenuItem(menu, 64);
            menuItemForOtherScopes.setData((Object)contributionItem);
            menuItemForOtherScopes.setText(Messages.EditorCommandsMenuContributor_CommandsForOtherScopes);
            Menu menuForOtherScopes = new Menu(menu);
            menuItemForOtherScopes.setMenu(menuForOtherScopes);
            EditorCommandsMenuContributor.buildMenu(menuForOtherScopes, menusFromOtherScopes, textEditor, scope, contributionItem);
        }
    }

    protected static IContentTypeTranslator getContentTypeTranslator() {
        return CommonEditorPlugin.getDefault().getContentTypeTranslator();
    }

    private static void buildMenu(Menu menu, List<MenuElement> menusFromScope, final ITextEditor textEditor, String scope, IContributionItem contributionItem) {
        MenuElement menuForScope2;
        for (MenuElement menuForScope2 : menusFromScope) {
            if (menuForScope2.isHierarchicalMenu()) {
                MenuItem menuItem = new MenuItem(menu, 64);
                menuItem.setData((Object)contributionItem);
                menuItem.setText(menuForScope2.getDisplayName());
                Menu menuForMenuForScope = new Menu(menu);
                menuItem.setMenu(menuForMenuForScope);
                EditorCommandsMenuContributor.buildMenu(menuForMenuForScope, menuForScope2.getChildren(), textEditor, scope, contributionItem);
                continue;
            }
            if (menuForScope2.isSeparator()) {
                MenuItem separatorMenuItem = new MenuItem(menu, 2);
                separatorMenuItem.setData((Object)contributionItem);
                continue;
            }
            final CommandElement command = menuForScope2.getCommand();
            if (command != null && !command.isExecutable()) continue;
            final MenuItem menuItem = new MenuItem(menu, 8);
            menuItem.setData((Object)contributionItem);
            String displayName = menuForScope2.getDisplayName();
            String acceleratorText = "";
            if (command != null) {
                String[] triggers;
                KeySequence[] keySequences = KeyBindingUtil.getKeySequences((CommandElement)command);
                if (keySequences != null && keySequences.length > 0) {
                    KeySequence keySequence = keySequences[0];
                    acceleratorText = "\t" + keySequence.format();
                }
                if ((command instanceof SnippetElement || keySequences == null || keySequences.length == 0) && (triggers = command.getTriggerTypeValues(TriggerType.PREFIX)) != null && triggers.length > 0) {
                    displayName = String.valueOf(displayName) + " " + triggers[0] + EditorCommandsMenuContributor.getTabChar();
                }
            }
            menuItem.setText(String.valueOf(displayName) + acceleratorText);
            menuItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (command == null) {
                        MessageDialog.openError((Shell)menuItem.getParent().getShell(), (String)Messages.EditorCommandsMenuContributor_TITLE_CommandNotDefined, (String)Messages.bind((String)Messages.EditorCommandsMenuContributor_MSG_CommandNotDefined, (Object)menuItem.getText()));
                    } else {
                        CommandResult commandResult = CommandExecutionUtils.executeCommand((CommandElement)command, (InvocationType)InvocationType.MENU, (ITextEditor)textEditor);
                        if (commandResult == null) {
                            BundleElement bundle = command.getOwningBundle();
                            String bundleName = bundle == null ? "Unknown bundle" : bundle.getDisplayName();
                            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (String)MessageFormat.format(Messages.EditorCommandsMenuContributor_ErrorExecutingCommandNullResult, command.getDisplayName(), bundleName));
                        } else {
                            CommandExecutionUtils.processCommandResult((CommandElement)command, (CommandResult)commandResult, (ITextEditor)textEditor);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            menuItem.setEnabled(command == null || command.getScope() == null || command.getScopeSelector().matches(scope));
        }
        if (menusFromScope.size() > 0 && (menuForScope2 = menusFromScope.get(0)).getParent() != null && menuForScope2.getParent().getParent() == null) {
            MenuItem separatorMenuItem = new MenuItem(menu, 2);
            separatorMenuItem.setData((Object)contributionItem);
            MenuItem editBundleItem = new MenuItem(menu, 8);
            editBundleItem.setData((Object)contributionItem);
            editBundleItem.setText(Messages.EditorCommandsMenuContributor_LBL_EditBundle);
            final BundleElement bundleElement = menuForScope2.getOwningBundle();
            editBundleItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditorCommandsMenuContributor.editBundle(bundleElement);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
    }

    private static String getTabChar() {
        if (Platform.getOS().equals("macosx")) {
            return "\u21e5";
        }
        return TAB;
    }

    protected static void editBundle(BundleElement owningBundle) {
        EditBundleJob job = new EditBundleJob(owningBundle);
        job.schedule();
    }

    public static class Factory
    implements IAdapterFactory {
        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (IEditorCommandsMenuContributor.class == adapterType) {
                return new TextEditorCommandsMenuContributor();
            }
            return null;
        }

        public Class[] getAdapterList() {
            return new Class[]{IEditorActionBarContributor.class};
        }
    }

    private static class TextEditorCommandsMenuContributor
    implements IEditorCommandsMenuContributor {
        private TextEditorCommandsMenuContributor() {
        }

        public void fill(Menu menu, ITextEditor textEditor) {
            EditorCommandsMenuContributor.fill(menu, textEditor);
        }
    }
}

